package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum MacOSSoftwareUpdateScheduleType implements Enum {

    @JsonProperty("alwaysUpdate")
    ALWAYS_UPDATE("alwaysUpdate", "0"),

    @JsonProperty("updateDuringTimeWindows")
    UPDATE_DURING_TIME_WINDOWS("updateDuringTimeWindows", "1"),

    @JsonProperty("updateOutsideOfTimeWindows")
    UPDATE_OUTSIDE_OF_TIME_WINDOWS("updateOutsideOfTimeWindows", "2");

    private final String name;
    private final String value;

    private MacOSSoftwareUpdateScheduleType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
