package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum MacOSSoftwareUpdateDelayPolicy implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("delayOSUpdateVisibility")
    DELAY_OSUPDATE_VISIBILITY("delayOSUpdateVisibility", "1"),

    @JsonProperty("delayAppUpdateVisibility")
    DELAY_APP_UPDATE_VISIBILITY("delayAppUpdateVisibility", "2"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "4"),

    @JsonProperty("delayMajorOsUpdateVisibility")
    DELAY_MAJOR_OS_UPDATE_VISIBILITY("delayMajorOsUpdateVisibility", "8");

    private final String name;
    private final String value;

    private MacOSSoftwareUpdateDelayPolicy(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
