package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum MacOSSoftwareUpdateCategory implements Enum {

    @JsonProperty("critical")
    CRITICAL("critical", "0"),

    @JsonProperty("configurationDataFile")
    CONFIGURATION_DATA_FILE("configurationDataFile", "1"),

    @JsonProperty("firmware")
    FIRMWARE("firmware", "2"),

    @JsonProperty("other")
    OTHER("other", "3");

    private final String name;
    private final String value;

    private MacOSSoftwareUpdateCategory(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
