package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum MacOSSoftwareUpdateBehavior implements Enum {

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "0"),

    @JsonProperty("default")
    DEFAULT("default", "1"),

    @JsonProperty("downloadOnly")
    DOWNLOAD_ONLY("downloadOnly", "2"),

    @JsonProperty("installASAP")
    INSTALL_ASAP("installASAP", "3"),

    @JsonProperty("notifyOnly")
    NOTIFY_ONLY("notifyOnly", "4"),

    @JsonProperty("installLater")
    INSTALL_LATER("installLater", "5");

    private final String name;
    private final String value;

    private MacOSSoftwareUpdateBehavior(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
