package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum MacOSContentCachingPeerPolicy implements Enum {

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "0"),

    @JsonProperty("peersInLocalNetwork")
    PEERS_IN_LOCAL_NETWORK("peersInLocalNetwork", "1"),

    @JsonProperty("peersWithSamePublicIpAddress")
    PEERS_WITH_SAME_PUBLIC_IP_ADDRESS("peersWithSamePublicIpAddress", "2"),

    @JsonProperty("peersInCustomLocalNetworks")
    PEERS_IN_CUSTOM_LOCAL_NETWORKS("peersInCustomLocalNetworks", "3");

    private final String name;
    private final String value;

    private MacOSContentCachingPeerPolicy(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
