package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum LongRunningOperationStatus implements Enum {

    @JsonProperty("notStarted")
    NOT_STARTED("notStarted", "0"),

    @JsonProperty("running")
    RUNNING("running", "1"),

    @JsonProperty("succeeded")
    SUCCEEDED("succeeded", "2"),

    @JsonProperty("failed")
    FAILED("failed", "3"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "4");

    private final String name;
    private final String value;

    private LongRunningOperationStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
