package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum LogonType implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("interactive")
    INTERACTIVE("interactive", "1"),

    @JsonProperty("remoteInteractive")
    REMOTE_INTERACTIVE("remoteInteractive", "2"),

    @JsonProperty("network")
    NETWORK("network", "3"),

    @JsonProperty("batch")
    BATCH("batch", "4"),

    @JsonProperty("service")
    SERVICE("service", "5"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "127");

    private final String name;
    private final String value;

    private LogonType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
