package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum LocationUniqueIdType implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("locationStore")
    LOCATION_STORE("locationStore", "1"),

    @JsonProperty("directory")
    DIRECTORY("directory", "2"),

    @JsonProperty("private")
    PRIVATE("private", "3"),

    @JsonProperty("bing")
    BING("bing", "4");

    private final String name;
    private final String value;

    private LocationUniqueIdType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
