package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum LobbyBypassScope implements Enum {

    @JsonProperty("organizer")
    ORGANIZER("organizer", "0"),

    @JsonProperty("organization")
    ORGANIZATION("organization", "1"),

    @JsonProperty("organizationAndFederated")
    ORGANIZATION_AND_FEDERATED("organizationAndFederated", "2"),

    @JsonProperty("everyone")
    EVERYONE("everyone", "3"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "4"),

    @JsonProperty("invited")
    INVITED("invited", "5"),

    @JsonProperty("organizationExcludingGuests")
    ORGANIZATION_EXCLUDING_GUESTS("organizationExcludingGuests", "6");

    private final String name;
    private final String value;

    private LobbyBypassScope(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
