package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum JobHistorySummaryType implements Enum {

    @JsonProperty("Printer")
    PRINTER("Printer", "0"),

    @JsonProperty("User")
    USER("User", "1"),

    @JsonProperty("Group")
    GROUP("Group", "2");

    private final String name;
    private final String value;

    private JobHistorySummaryType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
