package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum IosUpdatesInstallStatus implements Enum {

    @JsonProperty("updateScanFailed")
    UPDATE_SCAN_FAILED("updateScanFailed", "-2016324062"),

    @JsonProperty("deviceOsHigherThanDesiredOsVersion")
    DEVICE_OS_HIGHER_THAN_DESIRED_OS_VERSION("deviceOsHigherThanDesiredOsVersion", "-2016330696"),

    @JsonProperty("updateError")
    UPDATE_ERROR("updateError", "-2016330697"),

    @JsonProperty("sharedDeviceUserLoggedInError")
    SHARED_DEVICE_USER_LOGGED_IN_ERROR("sharedDeviceUserLoggedInError", "-2016330699"),

    @JsonProperty("notSupportedOperation")
    NOT_SUPPORTED_OPERATION("notSupportedOperation", "-2016330701"),

    @JsonProperty("installFailed")
    INSTALL_FAILED("installFailed", "-2016330702"),

    @JsonProperty("installPhoneCallInProgress")
    INSTALL_PHONE_CALL_IN_PROGRESS("installPhoneCallInProgress", "-2016330703"),

    @JsonProperty("installInsufficientPower")
    INSTALL_INSUFFICIENT_POWER("installInsufficientPower", "-2016330704"),

    @JsonProperty("installInsufficientSpace")
    INSTALL_INSUFFICIENT_SPACE("installInsufficientSpace", "-2016330705"),

    @JsonProperty("installing")
    INSTALLING("installing", "-2016330706"),

    @JsonProperty("downloadInsufficientNetwork")
    DOWNLOAD_INSUFFICIENT_NETWORK("downloadInsufficientNetwork", "-2016330707"),

    @JsonProperty("downloadInsufficientPower")
    DOWNLOAD_INSUFFICIENT_POWER("downloadInsufficientPower", "-2016330708"),

    @JsonProperty("downloadInsufficientSpace")
    DOWNLOAD_INSUFFICIENT_SPACE("downloadInsufficientSpace", "-2016330709"),

    @JsonProperty("downloadRequiresComputer")
    DOWNLOAD_REQUIRES_COMPUTER("downloadRequiresComputer", "-2016330710"),

    @JsonProperty("downloadFailed")
    DOWNLOAD_FAILED("downloadFailed", "-2016330711"),

    @JsonProperty("downloading")
    DOWNLOADING("downloading", "-2016330712"),

    @JsonProperty("timeout")
    TIMEOUT("timeout", "-2016333898"),

    @JsonProperty("mdmClientCrashed")
    MDM_CLIENT_CRASHED("mdmClientCrashed", "-2016336109"),

    @JsonProperty("success")
    SUCCESS("success", "0"),

    @JsonProperty("available")
    AVAILABLE("available", "1"),

    @JsonProperty("idle")
    IDLE("idle", "2"),

    @JsonProperty("unknown")
    UNKNOWN("unknown", "3");

    private final String name;
    private final String value;

    private IosUpdatesInstallStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
