package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum IosNotificationPreviewVisibility implements Enum {

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "0"),

    @JsonProperty("alwaysShow")
    ALWAYS_SHOW("alwaysShow", "1"),

    @JsonProperty("hideWhenLocked")
    HIDE_WHEN_LOCKED("hideWhenLocked", "2"),

    @JsonProperty("neverShow")
    NEVER_SHOW("neverShow", "3");

    private final String name;
    private final String value;

    private IosNotificationPreviewVisibility(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
