package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum InstallIntent implements Enum {

    @JsonProperty("available")
    AVAILABLE("available", "0"),

    @JsonProperty("required")
    REQUIRED("required", "1"),

    @JsonProperty("uninstall")
    UNINSTALL("uninstall", "2"),

    @JsonProperty("availableWithoutEnrollment")
    AVAILABLE_WITHOUT_ENROLLMENT("availableWithoutEnrollment", "3");

    private final String name;
    private final String value;

    private InstallIntent(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
