package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum IncludedUserRoles implements Enum {

    @JsonProperty("all")
    ALL("all", "0"),

    @JsonProperty("privilegedAdmin")
    PRIVILEGED_ADMIN("privilegedAdmin", "1"),

    @JsonProperty("admin")
    ADMIN("admin", "2"),

    @JsonProperty("user")
    USER("user", "3"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "4");

    private final String name;
    private final String value;

    private IncludedUserRoles(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
