package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum Importance implements Enum {

    @JsonProperty("low")
    LOW("low", "0"),

    @JsonProperty("normal")
    NORMAL("normal", "1"),

    @JsonProperty("high")
    HIGH("high", "2");

    private final String name;
    private final String value;

    private Importance(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
