package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum IdentityUserFlowAttributeInputType implements Enum {

    @JsonProperty("textBox")
    TEXT_BOX("textBox", "1"),

    @JsonProperty("dateTimeDropdown")
    DATE_TIME_DROPDOWN("dateTimeDropdown", "2"),

    @JsonProperty("radioSingleSelect")
    RADIO_SINGLE_SELECT("radioSingleSelect", "3"),

    @JsonProperty("dropdownSingleSelect")
    DROPDOWN_SINGLE_SELECT("dropdownSingleSelect", "4"),

    @JsonProperty("emailBox")
    EMAIL_BOX("emailBox", "5"),

    @JsonProperty("checkboxMultiSelect")
    CHECKBOX_MULTI_SELECT("checkboxMultiSelect", "6");

    private final String name;
    private final String value;

    private IdentityUserFlowAttributeInputType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
