package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum GroupPolicyUploadedDefinitionFileStatus implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("uploadInProgress")
    UPLOAD_IN_PROGRESS("uploadInProgress", "1"),

    @JsonProperty("available")
    AVAILABLE("available", "2"),

    @JsonProperty("assigned")
    ASSIGNED("assigned", "3"),

    @JsonProperty("removalInProgress")
    REMOVAL_IN_PROGRESS("removalInProgress", "4"),

    @JsonProperty("uploadFailed")
    UPLOAD_FAILED("uploadFailed", "5"),

    @JsonProperty("removalFailed")
    REMOVAL_FAILED("removalFailed", "6");

    private final String name;
    private final String value;

    private GroupPolicyUploadedDefinitionFileStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
