package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum GroupPolicySettingType implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("policy")
    POLICY("policy", "1"),

    @JsonProperty("account")
    ACCOUNT("account", "2"),

    @JsonProperty("securityOptions")
    SECURITY_OPTIONS("securityOptions", "3"),

    @JsonProperty("userRightsAssignment")
    USER_RIGHTS_ASSIGNMENT("userRightsAssignment", "4"),

    @JsonProperty("auditSetting")
    AUDIT_SETTING("auditSetting", "5"),

    @JsonProperty("windowsFirewallSettings")
    WINDOWS_FIREWALL_SETTINGS("windowsFirewallSettings", "6"),

    @JsonProperty("appLockerRuleCollection")
    APP_LOCKER_RULE_COLLECTION("appLockerRuleCollection", "7"),

    @JsonProperty("dataSourcesSettings")
    DATA_SOURCES_SETTINGS("dataSourcesSettings", "8"),

    @JsonProperty("devicesSettings")
    DEVICES_SETTINGS("devicesSettings", "9"),

    @JsonProperty("driveMapSettings")
    DRIVE_MAP_SETTINGS("driveMapSettings", "10"),

    @JsonProperty("environmentVariables")
    ENVIRONMENT_VARIABLES("environmentVariables", "11"),

    @JsonProperty("filesSettings")
    FILES_SETTINGS("filesSettings", "12"),

    @JsonProperty("folderOptions")
    FOLDER_OPTIONS("folderOptions", "13"),

    @JsonProperty("folders")
    FOLDERS("folders", "14"),

    @JsonProperty("iniFiles")
    INI_FILES("iniFiles", "15"),

    @JsonProperty("internetOptions")
    INTERNET_OPTIONS("internetOptions", "16"),

    @JsonProperty("localUsersAndGroups")
    LOCAL_USERS_AND_GROUPS("localUsersAndGroups", "17"),

    @JsonProperty("networkOptions")
    NETWORK_OPTIONS("networkOptions", "18"),

    @JsonProperty("networkShares")
    NETWORK_SHARES("networkShares", "19"),

    @JsonProperty("ntServices")
    NT_SERVICES("ntServices", "20"),

    @JsonProperty("powerOptions")
    POWER_OPTIONS("powerOptions", "21"),

    @JsonProperty("printers")
    PRINTERS("printers", "22"),

    @JsonProperty("regionalOptionsSettings")
    REGIONAL_OPTIONS_SETTINGS("regionalOptionsSettings", "23"),

    @JsonProperty("registrySettings")
    REGISTRY_SETTINGS("registrySettings", "24"),

    @JsonProperty("scheduledTasks")
    SCHEDULED_TASKS("scheduledTasks", "25"),

    @JsonProperty("shortcutSettings")
    SHORTCUT_SETTINGS("shortcutSettings", "26"),

    @JsonProperty("startMenuSettings")
    START_MENU_SETTINGS("startMenuSettings", "27");

    private final String name;
    private final String value;

    private GroupPolicySettingType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
