package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum FollowupFlagStatus implements Enum {

    @JsonProperty("notFlagged")
    NOT_FLAGGED("notFlagged", "0"),

    @JsonProperty("complete")
    COMPLETE("complete", "1"),

    @JsonProperty("flagged")
    FLAGGED("flagged", "2");

    private final String name;
    private final String value;

    private FollowupFlagStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
