package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum FolderProtectionType implements Enum {

    @JsonProperty("userDefined")
    USER_DEFINED("userDefined", "0"),

    @JsonProperty("enable")
    ENABLE("enable", "1"),

    @JsonProperty("auditMode")
    AUDIT_MODE("auditMode", "2"),

    @JsonProperty("blockDiskModification")
    BLOCK_DISK_MODIFICATION("blockDiskModification", "3"),

    @JsonProperty("auditDiskModification")
    AUDIT_DISK_MODIFICATION("auditDiskModification", "4");

    private final String name;
    private final String value;

    private FolderProtectionType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
