package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum FirewallCertificateRevocationListCheckMethodType implements Enum {

    @JsonProperty("deviceDefault")
    DEVICE_DEFAULT("deviceDefault", "0"),

    @JsonProperty("none")
    NONE("none", "1"),

    @JsonProperty("attempt")
    ATTEMPT("attempt", "2"),

    @JsonProperty("require")
    REQUIRE("require", "3");

    private final String name;
    private final String value;

    private FirewallCertificateRevocationListCheckMethodType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
