package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum FileHashType implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("sha1")
    SHA1("sha1", "1"),

    @JsonProperty("sha256")
    SHA256("sha256", "2"),

    @JsonProperty("md5")
    MD5("md5", "3"),

    @JsonProperty("authenticodeHash256")
    AUTHENTICODE_HASH256("authenticodeHash256", "4"),

    @JsonProperty("lsHash")
    LS_HASH("lsHash", "5"),

    @JsonProperty("ctph")
    CTPH("ctph", "6"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "127");

    private final String name;
    private final String value;

    private FileHashType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
