package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ExpirationRequirement implements Enum {

    @JsonProperty("rememberMultifactorAuthenticationOnTrustedDevices")
    REMEMBER_MULTIFACTOR_AUTHENTICATION_ON_TRUSTED_DEVICES("rememberMultifactorAuthenticationOnTrustedDevices", "0"),

    @JsonProperty("tenantTokenLifetimePolicy")
    TENANT_TOKEN_LIFETIME_POLICY("tenantTokenLifetimePolicy", "1"),

    @JsonProperty("audienceTokenLifetimePolicy")
    AUDIENCE_TOKEN_LIFETIME_POLICY("audienceTokenLifetimePolicy", "2"),

    @JsonProperty("signInFrequencyPeriodicReauthentication")
    SIGN_IN_FREQUENCY_PERIODIC_REAUTHENTICATION("signInFrequencyPeriodicReauthentication", "3"),

    @JsonProperty("ngcMfa")
    NGC_MFA("ngcMfa", "4"),

    @JsonProperty("signInFrequencyEveryTime")
    SIGN_IN_FREQUENCY_EVERY_TIME("signInFrequencyEveryTime", "5"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "6");

    private final String name;
    private final String value;

    private ExpirationRequirement(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
