package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ExchangeIdFormat implements Enum {

    @JsonProperty("entryId")
    ENTRY_ID("entryId", "0"),

    @JsonProperty("ewsId")
    EWS_ID("ewsId", "1"),

    @JsonProperty("immutableEntryId")
    IMMUTABLE_ENTRY_ID("immutableEntryId", "2"),

    @JsonProperty("restId")
    REST_ID("restId", "3"),

    @JsonProperty("restImmutableEntryId")
    REST_IMMUTABLE_ENTRY_ID("restImmutableEntryId", "4");

    private final String name;
    private final String value;

    private ExchangeIdFormat(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
