package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum EndpointType implements Enum {

    @JsonProperty("default")
    DEFAULT("default", "0"),

    @JsonProperty("voicemail")
    VOICEMAIL("voicemail", "1"),

    @JsonProperty("skypeForBusiness")
    SKYPE_FOR_BUSINESS("skypeForBusiness", "2"),

    @JsonProperty("skypeForBusinessVoipPhone")
    SKYPE_FOR_BUSINESS_VOIP_PHONE("skypeForBusinessVoipPhone", "3"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "4");

    private final String name;
    private final String value;

    private EndpointType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
