package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum EndpointSecurityConfigurationType implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("antivirus")
    ANTIVIRUS("antivirus", "1"),

    @JsonProperty("diskEncryption")
    DISK_ENCRYPTION("diskEncryption", "2"),

    @JsonProperty("firewall")
    FIREWALL("firewall", "3"),

    @JsonProperty("endpointDetectionAndResponse")
    ENDPOINT_DETECTION_AND_RESPONSE("endpointDetectionAndResponse", "4"),

    @JsonProperty("attackSurfaceReduction")
    ATTACK_SURFACE_REDUCTION("attackSurfaceReduction", "5"),

    @JsonProperty("accountProtection")
    ACCOUNT_PROTECTION("accountProtection", "6");

    private final String name;
    private final String value;

    private EndpointSecurityConfigurationType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
