package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum EndpointSecurityConfigurationProfileType implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("antivirus")
    ANTIVIRUS("antivirus", "1"),

    @JsonProperty("windowsSecurity")
    WINDOWS_SECURITY("windowsSecurity", "2"),

    @JsonProperty("bitLocker")
    BIT_LOCKER("bitLocker", "3"),

    @JsonProperty("fileVault")
    FILE_VAULT("fileVault", "4"),

    @JsonProperty("firewall")
    FIREWALL("firewall", "5"),

    @JsonProperty("firewallRules")
    FIREWALL_RULES("firewallRules", "6"),

    @JsonProperty("endpointDetectionAndResponse")
    ENDPOINT_DETECTION_AND_RESPONSE("endpointDetectionAndResponse", "7"),

    @JsonProperty("deviceControl")
    DEVICE_CONTROL("deviceControl", "8"),

    @JsonProperty("appAndBrowserIsolation")
    APP_AND_BROWSER_ISOLATION("appAndBrowserIsolation", "9"),

    @JsonProperty("exploitProtection")
    EXPLOIT_PROTECTION("exploitProtection", "10"),

    @JsonProperty("webProtection")
    WEB_PROTECTION("webProtection", "11"),

    @JsonProperty("applicationControl")
    APPLICATION_CONTROL("applicationControl", "12"),

    @JsonProperty("attackSurfaceReductionRules")
    ATTACK_SURFACE_REDUCTION_RULES("attackSurfaceReductionRules", "13"),

    @JsonProperty("accountProtection")
    ACCOUNT_PROTECTION("accountProtection", "14");

    private final String name;
    private final String value;

    private EndpointSecurityConfigurationProfileType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
