package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum EducationUserRole implements Enum {

    @JsonProperty("student")
    STUDENT("student", "0"),

    @JsonProperty("teacher")
    TEACHER("teacher", "1"),

    @JsonProperty("none")
    NONE("none", "2"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "3"),

    @JsonProperty("faculty")
    FACULTY("faculty", "4");

    private final String name;
    private final String value;

    private EducationUserRole(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
