package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum DriverCategory implements Enum {

    @JsonProperty("recommended")
    RECOMMENDED("recommended", "0"),

    @JsonProperty("previouslyApproved")
    PREVIOUSLY_APPROVED("previouslyApproved", "1"),

    @JsonProperty("other")
    OTHER("other", "2");

    private final String name;
    private final String value;

    private DriverCategory(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
