package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum DriverApprovalStatus implements Enum {

    @JsonProperty("needsReview")
    NEEDS_REVIEW("needsReview", "0"),

    @JsonProperty("declined")
    DECLINED("declined", "1"),

    @JsonProperty("approved")
    APPROVED("approved", "2"),

    @JsonProperty("suspended")
    SUSPENDED("suspended", "3");

    private final String name;
    private final String value;

    private DriverApprovalStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
