package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum DiscoverySource implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("adminImport")
    ADMIN_IMPORT("adminImport", "2"),

    @JsonProperty("deviceEnrollmentProgram")
    DEVICE_ENROLLMENT_PROGRAM("deviceEnrollmentProgram", "4");

    private final String name;
    private final String value;

    private DiscoverySource(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
