package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum DiffieHellmanGroup implements Enum {

    @JsonProperty("group1")
    GROUP1("group1", "0"),

    @JsonProperty("group2")
    GROUP2("group2", "1"),

    @JsonProperty("group14")
    GROUP14("group14", "2"),

    @JsonProperty("ecp256")
    ECP256("ecp256", "3"),

    @JsonProperty("ecp384")
    ECP384("ecp384", "4"),

    @JsonProperty("group24")
    GROUP24("group24", "5");

    private final String name;
    private final String value;

    private DiffieHellmanGroup(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
