package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum DeviceType implements Enum {

    @JsonProperty("desktop")
    DESKTOP("desktop", "0"),

    @JsonProperty("windowsRT")
    WINDOWS_RT("windowsRT", "1"),

    @JsonProperty("winMO6")
    WIN_MO6("winMO6", "2"),

    @JsonProperty("nokia")
    NOKIA("nokia", "3"),

    @JsonProperty("windowsPhone")
    WINDOWS_PHONE("windowsPhone", "4"),

    @JsonProperty("mac")
    MAC("mac", "5"),

    @JsonProperty("winCE")
    WIN_CE("winCE", "6"),

    @JsonProperty("winEmbedded")
    WIN_EMBEDDED("winEmbedded", "7"),

    @JsonProperty("iPhone")
    I_PHONE("iPhone", "8"),

    @JsonProperty("iPad")
    I_PAD("iPad", "9"),

    @JsonProperty("iPod")
    I_POD("iPod", "10"),

    @JsonProperty("android")
    ANDROID("android", "11"),

    @JsonProperty("iSocConsumer")
    I_SOC_CONSUMER("iSocConsumer", "12"),

    @JsonProperty("unix")
    UNIX("unix", "13"),

    @JsonProperty("macMDM")
    MAC_MDM("macMDM", "14"),

    @JsonProperty("holoLens")
    HOLO_LENS("holoLens", "15"),

    @JsonProperty("surfaceHub")
    SURFACE_HUB("surfaceHub", "16"),

    @JsonProperty("androidForWork")
    ANDROID_FOR_WORK("androidForWork", "17"),

    @JsonProperty("androidEnterprise")
    ANDROID_ENTERPRISE("androidEnterprise", "18"),

    @JsonProperty("windows10x")
    WINDOWS10X("windows10x", "19"),

    @JsonProperty("androidnGMS")
    ANDROIDN_GMS("androidnGMS", "20"),

    @JsonProperty("chromeOS")
    CHROME_OS("chromeOS", "21"),

    @JsonProperty("linux")
    LINUX("linux", "22"),

    @JsonProperty("blackberry")
    BLACKBERRY("blackberry", "100"),

    @JsonProperty("palm")
    PALM("palm", "101"),

    @JsonProperty("unknown")
    UNKNOWN("unknown", "255"),

    @JsonProperty("cloudPC")
    CLOUD_PC("cloudPC", "257");

    private final String name;
    private final String value;

    private DeviceType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
