package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum DeviceRegistrationState implements Enum {

    @JsonProperty("notRegistered")
    NOT_REGISTERED("notRegistered", "0"),

    @JsonProperty("registered")
    REGISTERED("registered", "2"),

    @JsonProperty("revoked")
    REVOKED("revoked", "3"),

    @JsonProperty("keyConflict")
    KEY_CONFLICT("keyConflict", "4"),

    @JsonProperty("approvalPending")
    APPROVAL_PENDING("approvalPending", "5"),

    @JsonProperty("certificateReset")
    CERTIFICATE_RESET("certificateReset", "6"),

    @JsonProperty("notRegisteredPendingEnrollment")
    NOT_REGISTERED_PENDING_ENROLLMENT("notRegisteredPendingEnrollment", "7"),

    @JsonProperty("unknown")
    UNKNOWN("unknown", "8");

    private final String name;
    private final String value;

    private DeviceRegistrationState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
