package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum DeviceManagementTemplateLifecycleState implements Enum {

    @JsonProperty("invalid")
    INVALID("invalid", "0"),

    @JsonProperty("draft")
    DRAFT("draft", "10"),

    @JsonProperty("active")
    ACTIVE("active", "20"),

    @JsonProperty("superseded")
    SUPERSEDED("superseded", "30"),

    @JsonProperty("deprecated")
    DEPRECATED("deprecated", "40"),

    @JsonProperty("retired")
    RETIRED("retired", "50");

    private final String name;
    private final String value;

    private DeviceManagementTemplateLifecycleState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
