package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum DeviceManagementSubscriptionState implements Enum {

    @JsonProperty("pending")
    PENDING("pending", "0"),

    @JsonProperty("active")
    ACTIVE("active", "1"),

    @JsonProperty("warning")
    WARNING("warning", "2"),

    @JsonProperty("disabled")
    DISABLED("disabled", "3"),

    @JsonProperty("deleted")
    DELETED("deleted", "4"),

    @JsonProperty("blocked")
    BLOCKED("blocked", "5"),

    @JsonProperty("lockedOut")
    LOCKED_OUT("lockedOut", "8");

    private final String name;
    private final String value;

    private DeviceManagementSubscriptionState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
