package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum DeviceManagementDerivedCredentialNotificationType implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("companyPortal")
    COMPANY_PORTAL("companyPortal", "1"),

    @JsonProperty("email")
    EMAIL("email", "2");

    private final String name;
    private final String value;

    private DeviceManagementDerivedCredentialNotificationType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
