package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum DeviceManagementConfigurationWindowsSkus implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("windowsHome")
    WINDOWS_HOME("windowsHome", "1"),

    @JsonProperty("windowsProfessional")
    WINDOWS_PROFESSIONAL("windowsProfessional", "2"),

    @JsonProperty("windowsEnterprise")
    WINDOWS_ENTERPRISE("windowsEnterprise", "3"),

    @JsonProperty("windowsEducation")
    WINDOWS_EDUCATION("windowsEducation", "4"),

    @JsonProperty("windowsMobile")
    WINDOWS_MOBILE("windowsMobile", "5"),

    @JsonProperty("windowsMobileEnterprise")
    WINDOWS_MOBILE_ENTERPRISE("windowsMobileEnterprise", "6"),

    @JsonProperty("windowsTeamSurface")
    WINDOWS_TEAM_SURFACE("windowsTeamSurface", "7"),

    @JsonProperty("iot")
    IOT("iot", "8"),

    @JsonProperty("iotEnterprise")
    IOT_ENTERPRISE("iotEnterprise", "9"),

    @JsonProperty("holoLens")
    HOLO_LENS("holoLens", "10"),

    @JsonProperty("holoLensEnterprise")
    HOLO_LENS_ENTERPRISE("holoLensEnterprise", "11"),

    @JsonProperty("holographicForBusiness")
    HOLOGRAPHIC_FOR_BUSINESS("holographicForBusiness", "12"),

    @JsonProperty("windowsMultiSession")
    WINDOWS_MULTI_SESSION("windowsMultiSession", "13"),

    @JsonProperty("surfaceHub")
    SURFACE_HUB("surfaceHub", "14");

    private final String name;
    private final String value;

    private DeviceManagementConfigurationWindowsSkus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
