package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum DeviceManagementConfigurationTemplateFamily implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("endpointSecurityAntivirus")
    ENDPOINT_SECURITY_ANTIVIRUS("endpointSecurityAntivirus", "10"),

    @JsonProperty("endpointSecurityDiskEncryption")
    ENDPOINT_SECURITY_DISK_ENCRYPTION("endpointSecurityDiskEncryption", "11"),

    @JsonProperty("endpointSecurityFirewall")
    ENDPOINT_SECURITY_FIREWALL("endpointSecurityFirewall", "12"),

    @JsonProperty("endpointSecurityEndpointDetectionAndResponse")
    ENDPOINT_SECURITY_ENDPOINT_DETECTION_AND_RESPONSE("endpointSecurityEndpointDetectionAndResponse", "13"),

    @JsonProperty("endpointSecurityAttackSurfaceReduction")
    ENDPOINT_SECURITY_ATTACK_SURFACE_REDUCTION("endpointSecurityAttackSurfaceReduction", "14"),

    @JsonProperty("endpointSecurityAccountProtection")
    ENDPOINT_SECURITY_ACCOUNT_PROTECTION("endpointSecurityAccountProtection", "15"),

    @JsonProperty("endpointSecurityApplicationControl")
    ENDPOINT_SECURITY_APPLICATION_CONTROL("endpointSecurityApplicationControl", "16"),

    @JsonProperty("baseline")
    BASELINE("baseline", "20");

    private final String name;
    private final String value;

    private DeviceManagementConfigurationTemplateFamily(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
