package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum DeviceManagementConfigurationTechnologies implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("mdm")
    MDM("mdm", "1"),

    @JsonProperty("windows10XManagement")
    WINDOWS10XMANAGEMENT("windows10XManagement", "2"),

    @JsonProperty("configManager")
    CONFIG_MANAGER("configManager", "4"),

    @JsonProperty("microsoftSense")
    MICROSOFT_SENSE("microsoftSense", "128"),

    @JsonProperty("exchangeOnline")
    EXCHANGE_ONLINE("exchangeOnline", "256"),

    @JsonProperty("linuxMdm")
    LINUX_MDM("linuxMdm", "1024"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "1073741824");

    private final String name;
    private final String value;

    private DeviceManagementConfigurationTechnologies(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
