package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum DeviceManagementConfigurationSettingUsage implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("configuration")
    CONFIGURATION("configuration", "1"),

    @JsonProperty("compliance")
    COMPLIANCE("compliance", "2");

    private final String name;
    private final String value;

    private DeviceManagementConfigurationSettingUsage(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
