package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum DeviceManagementConfigurationPlatforms implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("android")
    ANDROID("android", "1"),

    @JsonProperty("iOS")
    I_OS("iOS", "4"),

    @JsonProperty("macOS")
    MAC_OS("macOS", "8"),

    @JsonProperty("windows10X")
    WINDOWS10X("windows10X", "16"),

    @JsonProperty("windows10")
    WINDOWS10("windows10", "32"),

    @JsonProperty("linux")
    LINUX("linux", "128"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "1073741824");

    private final String name;
    private final String value;

    private DeviceManagementConfigurationPlatforms(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
