package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum DeviceManagementConfigurationControlType implements Enum {

    @JsonProperty("default")
    DEFAULT("default", "0"),

    @JsonProperty("dropdown")
    DROPDOWN("dropdown", "1"),

    @JsonProperty("smallTextBox")
    SMALL_TEXT_BOX("smallTextBox", "2"),

    @JsonProperty("largeTextBox")
    LARGE_TEXT_BOX("largeTextBox", "3"),

    @JsonProperty("toggle")
    TOGGLE("toggle", "4"),

    @JsonProperty("multiheaderGrid")
    MULTIHEADER_GRID("multiheaderGrid", "5"),

    @JsonProperty("contextPane")
    CONTEXT_PANE("contextPane", "6");

    private final String name;
    private final String value;

    private DeviceManagementConfigurationControlType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
