package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum DeviceManagementComplianceActionType implements Enum {

    @JsonProperty("noAction")
    NO_ACTION("noAction", "0"),

    @JsonProperty("notification")
    NOTIFICATION("notification", "1"),

    @JsonProperty("block")
    BLOCK("block", "2"),

    @JsonProperty("retire")
    RETIRE("retire", "3"),

    @JsonProperty("wipe")
    WIPE("wipe", "4"),

    @JsonProperty("removeResourceAccessProfiles")
    REMOVE_RESOURCE_ACCESS_PROFILES("removeResourceAccessProfiles", "5"),

    @JsonProperty("pushNotification")
    PUSH_NOTIFICATION("pushNotification", "9"),

    @JsonProperty("remoteLock")
    REMOTE_LOCK("remoteLock", "10");

    private final String name;
    private final String value;

    private DeviceManagementComplianceActionType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
