package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum DeviceGuardLocalSystemAuthorityCredentialGuardType implements Enum {

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "0"),

    @JsonProperty("enableWithUEFILock")
    ENABLE_WITH_UEFILOCK("enableWithUEFILock", "1"),

    @JsonProperty("enableWithoutUEFILock")
    ENABLE_WITHOUT_UEFILOCK("enableWithoutUEFILock", "2"),

    @JsonProperty("disable")
    DISABLE("disable", "3");

    private final String name;
    private final String value;

    private DeviceGuardLocalSystemAuthorityCredentialGuardType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
