package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum DeviceGuardLocalSystemAuthorityCredentialGuardState implements Enum {

    @JsonProperty("running")
    RUNNING("running", "0"),

    @JsonProperty("rebootRequired")
    REBOOT_REQUIRED("rebootRequired", "1"),

    @JsonProperty("notLicensed")
    NOT_LICENSED("notLicensed", "2"),

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "3"),

    @JsonProperty("virtualizationBasedSecurityNotRunning")
    VIRTUALIZATION_BASED_SECURITY_NOT_RUNNING("virtualizationBasedSecurityNotRunning", "4");

    private final String name;
    private final String value;

    private DeviceGuardLocalSystemAuthorityCredentialGuardState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
