package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum DeviceCustomAttributeValueType implements Enum {

    @JsonProperty("integer")
    INTEGER("integer", "0"),

    @JsonProperty("string")
    STRING("string", "1"),

    @JsonProperty("dateTime")
    DATE_TIME("dateTime", "2");

    private final String name;
    private final String value;

    private DeviceCustomAttributeValueType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
