package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum DeviceComplianceScriptRuleDataType implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("boolean")
    BOOLEAN("boolean", "1"),

    @JsonProperty("int64")
    INT64("int64", "2"),

    @JsonProperty("double")
    DOUBLE("double", "3"),

    @JsonProperty("string")
    STRING("string", "4"),

    @JsonProperty("dateTime")
    DATE_TIME("dateTime", "5"),

    @JsonProperty("version")
    VERSION("version", "6"),

    @JsonProperty("base64")
    BASE64("base64", "7"),

    @JsonProperty("xml")
    XML("xml", "8"),

    @JsonProperty("booleanArray")
    BOOLEAN_ARRAY("booleanArray", "9"),

    @JsonProperty("int64Array")
    INT64ARRAY("int64Array", "10"),

    @JsonProperty("doubleArray")
    DOUBLE_ARRAY("doubleArray", "11"),

    @JsonProperty("stringArray")
    STRING_ARRAY("stringArray", "12"),

    @JsonProperty("dateTimeArray")
    DATE_TIME_ARRAY("dateTimeArray", "13"),

    @JsonProperty("versionArray")
    VERSION_ARRAY("versionArray", "14");

    private final String name;
    private final String value;

    private DeviceComplianceScriptRuleDataType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
