package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum DeviceAndAppManagementAssignmentFilterType implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("include")
    INCLUDE("include", "1"),

    @JsonProperty("exclude")
    EXCLUDE("exclude", "2");

    private final String name;
    private final String value;

    private DeviceAndAppManagementAssignmentFilterType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
