package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum DelegatedAdminRelationshipOperationType implements Enum {

    @JsonProperty("delegatedAdminAccessAssignmentUpdate")
    DELEGATED_ADMIN_ACCESS_ASSIGNMENT_UPDATE("delegatedAdminAccessAssignmentUpdate", "0"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "1");

    private final String name;
    private final String value;

    private DelegatedAdminRelationshipOperationType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
